using UnityEngine;

public class MenuScript : MonoBehaviour {
	public GameObject countryManager;

	private string[] countries = CountryManagerScript.GetCountryList();
	private int player1sel = -1;
	private int player2sel = -2;
	
	private CountryManagerScript cman;
	
	void Start () {
		cman = (CountryManagerScript)countryManager.GetComponent(typeof(CountryManagerScript));
	}
	
	void OnGUI() {
		
		int ww = Screen.width;
		int hh = Screen.height;
		
		GUIStyle style = new GUIStyle("label");
		style.alignment = TextAnchor.MiddleCenter;
		
    	GUI.Label (new Rect(ww*0.3f,hh*0.1f,ww*0.2f,hh*0.05f), "Player 1", style );
    	GUI.Label (new Rect(ww*0.5f,hh*0.1f,ww*0.2f,hh*0.05f), "Player 2", style );
		
		buildCountryList(new Rect (ww*0.30f, hh*0.15f, ww*0.19f, hh*0.7f), ref player1sel, ref player2sel);
		buildCountryList(new Rect (ww*0.51f, hh*0.15f, ww*0.19f, hh*0.7f), ref player2sel, ref player1sel);
		
		GUI.enabled = player1sel >= 0 && player2sel >= 0;
    	if (GUI.Button( new Rect(ww/4, hh*0.86f, ww/2, hh*0.09f), "Start!"))
    	{
    		ChosenPlayers.instance.player1 = player1sel;
    		ChosenPlayers.instance.player2 = player2sel;
    		Application.LoadLevel(Application.loadedLevel+1);
    	}
		GUI.enabled = true;
	}
	
	void buildCountryList(Rect rect, ref int sel1, ref int sel2)
	{
		Rect rc = rect;
		rc.height = rect.height / countries.Length - 1;
		GUIStyle style = new GUIStyle("button");
		style.alignment = TextAnchor.MiddleLeft;
		
		for (int i = 0; i < countries.Length; i++)
		{
			GUI.enabled = i != sel2;
			if (GUI.Toggle(rc,sel1 == i, new GUIContent((string)countries[i], cman.flags[i]), style))
				sel1 = i;	
			GUI.enabled = true;
			rc.y += rc.height + 1;
		}
	}
	
	void Update() {
		if (Input.GetKeyDown("escape")) {
			Application.LoadLevel (Application.loadedLevel-1);
		}
	}
}
